<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php hooks()->do_action('app_customers_portal_head'); ?>

<style>
    .repair-card-item {
        display: flex;
        margin-bottom: 25px;
    }
    .repair-card-panel {
        width: 100%;
        display: flex;
        flex-direction: column;
        margin-bottom: 0;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        background: #fff;
        transition: transform 0.2s;
        text-decoration: none !important;
    }
    .repair-card-panel:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    }
    .repair-card-header {
        padding: 15px;
        border-bottom: 1px solid #f3f4f6;
        background-color: #f9fafb;
        border-top-left-radius: 8px;
        border-top-right-radius: 8px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .repair-card-body {
        padding: 15px;
        flex: 1;
    }
    .repair-info-row {
        display: flex;
        margin-bottom: 8px;
        font-size: 13px;
    }
    .repair-info-label {
        width: 40%;
        color: #6b7280;
    }
    .repair-info-value {
        width: 60%;
        font-weight: 600;
        color: #374151;
        white-space: nowrap; 
        overflow: hidden; 
        text-overflow: ellipsis;
    }
    .status-badge {
        font-size: 11px;
        padding: 3px 8px;
        border-radius: 12px;
        text-transform: uppercase;
        font-weight: bold;
    }
</style>

<div class="col-md-12">
    <div class="row">
        <div class="col-md-6">
            <h4 class="tw-mt-0 tw-font-semibold tw-text-neutral-700 section-heading section-heading-invoices">
                <?php echo e($title); ?>
            </h4>
        </div>
        <div class="col-md-6 text-right">
             <div class="btn-group" role="group">
                <button type="button" class="btn btn-default active" id="btn-grid-view" onclick="wshop_switch_view('grid')"><i class="fa fa-th-large"></i></button>
                <button type="button" class="btn btn-default" id="btn-list-view" onclick="wshop_switch_view('list')"><i class="fa fa-list"></i></button>
            </div>
        </div>
    </div>

    <!-- GRID VIEW -->
    <div id="wshop-grid-view">
        <div class="row" style="display: flex; flex-wrap: wrap;">
            <?php foreach($repair_jobs as $repair_job){ 
                 $status_data = get_repair_job_status_by_id($repair_job['status'], '');
                 $status_color = isset($status_data['color']) ? $status_data['color'] : '#777';
                 $status_name = isset($status_data['name']) ? $status_data['name'] : _l('wshop_unknown');
                 
                 // Get readable device name if using joins or direct fetch
                 $device_name = isset($repair_job['device_name']) ? $repair_job['device_name'] : get_device_name($repair_job['device_id']);
            ?>
            <div class="col-lg-4 col-md-6 col-sm-6 repair-card-item">
                <div class="repair-card-panel">
                    <div class="repair-card-header">
                        <span class="bold text-info">
                            <?php echo $repair_job['job_tracking_number']; ?>
                        </span>
                        <span class="status-badge" style="background-color: <?php echo $status_color; ?>20; color: <?php echo $status_color; ?>; border: 1px solid <?php echo $status_color; ?>;">
                            <?php echo $status_name; ?>
                        </span>
                    </div>
                    
                    <div class="repair-card-body">
                         <div class="repair-info-row">
                             <div class="repair-info-label"><?php echo _l('wshop_device'); ?></div>
                             <div class="repair-info-value" title="<?php echo $device_name; ?>"><?php echo $device_name; ?></div>
                         </div>
                         <div class="repair-info-row">
                             <div class="repair-info-label"><?php echo _l('wshop_appointment_date'); ?></div>
                             <div class="repair-info-value"><?php echo _d($repair_job['appointment_date']); ?></div>
                         </div>
                         <div class="repair-info-row">
                             <div class="repair-info-label"><?php echo _l('wshop_estimated_completion_date'); ?></div>
                             <div class="repair-info-value"><?php echo _d($repair_job['estimated_completion_date']); ?></div>
                         </div>
                         
                         <?php if(isset($repair_job['total']) && $repair_job['total'] > 0){ ?>
                         <div class="repair-info-row">
                             <div class="repair-info-label"><?php echo _l('wshop_total'); ?></div>
                             <div class="repair-info-value"><?php echo app_format_money($repair_job['total'], $repair_job['currency']); ?></div>
                         </div>
                         <?php } ?>
                         
                         <div class="mtop15">
                             <a href="<?php echo site_url('workshop/client/repair_job_detail/'.$repair_job['id'].'?tab=detail'); ?>" class="btn btn-default btn-block">
                                 <?php echo _l('view'); ?> <i class="fa fa-arrow-right pull-right"></i>
                             </a>
                         </div>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>

    <!-- LIST VIEW -->
    <div id="wshop-list-view" class="hide">
        <div class="panel_s">
            <div class="panel-body">
                <?php $this->load->view('clients/repair_jobs/table_html'); ?>
            </div>
        </div>
    </div>
</div>

<script>
    function wshop_switch_view(view) {
        if (view == 'grid') {
            $('#wshop-grid-view').removeClass('hide');
            $('#wshop-list-view').addClass('hide');
            $('#btn-grid-view').addClass('active');
            $('#btn-list-view').removeClass('active');
        } else {
            $('#wshop-grid-view').addClass('hide');
            $('#wshop-list-view').removeClass('hide');
            $('#btn-grid-view').removeClass('active');
            $('#btn-list-view').addClass('active');
        }
    }
</script>

<?php workshop_client_init_tail(); ?>